/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigDrawable;
import jfig.canvas.FigDrawableEnumerator;
import jfig.canvas.FigTrafo2D;
import jfig.canvas.TopLeftRulerCanvas;
import jfig.canvas.ZoomListener;
import jfig.gui.FontCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigText;
import jfig.utils.BoundingBoxCalculator;
import jfig.utils.Format;

public class CanvasScroller
extends Panel
implements AdjustmentListener,
ComponentListener,
MouseMotionListener,
ZoomListener {
    private static boolean debug = false;
    protected FigCanvas editorCanvas;
    protected Panel bottomPanel;
    protected Panel labelPanel;
    protected Scrollbar scrollbarX;
    protected Scrollbar scrollbarY;
    protected Label coordLabel;
    protected Label zoomLabel;
    protected Filler filler;
    protected InfoLabel infoLabel;
    protected FigBbox objectBBox;
    protected FigBbox visibleRegionBBox;
    protected FigBbox totalBBox;
    protected boolean clipToObjectBoundingBox;

    public CanvasScroller(FigCanvas _canvas) {
        this.editorCanvas = _canvas;
        _canvas.addZoomListener(this);
        this.buildGUI();
        this.clipToObjectBoundingBox = true;
        this.rebuildBoundingBoxes();
    }

    public void setCanvas(FigCanvas _canvas) {
        this.editorCanvas = _canvas;
        this.add("Center", this.editorCanvas.getComponent());
        this.rebuildBoundingBoxes();
    }

    void buildGUI() {
        this.scrollbarY = new Scrollbar(1);
        this.bottomPanel = new Panel();
        this.scrollbarX = new Scrollbar(0);
        this.filler = new Filler();
        this.infoLabel = new InfoLabel();
        this.infoLabel.setWidth(this.infoLabel.measure());
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add("West", this.infoLabel);
        this.bottomPanel.add("Center", this.scrollbarX);
        this.bottomPanel.add("East", this.filler);
        this.setLayout(new BorderLayout());
        this.add("Center", this.editorCanvas.getComponent());
        this.add("East", this.scrollbarY);
        this.add("South", this.bottomPanel);
        this.scrollbarX.addAdjustmentListener(this);
        this.scrollbarY.addAdjustmentListener(this);
        this.editorCanvas.getComponent().addMouseMotionListener(this);
        this.editorCanvas.getComponent().addComponentListener(this);
    }

    public int getScrollbarWidth() {
        return this.scrollbarY.getSize().width;
    }

    public void doLayout() {
        int width;
        if (this.getScrollbarWidth() == 0) {
            super.doLayout();
        }
        if ((width = this.getScrollbarWidth()) != 0) {
            width = this.scrollbarY.getPreferredSize().width;
        }
        if (width != 0) {
            this.filler.setWidth(width);
            this.filler.setHeight(width);
            this.infoLabel.setHeight(width);
            this.rebuildScrollbars();
        }
        super.doLayout();
    }

    public void rebuildBoundingBoxes() {
        try {
            this.objectBBox = BoundingBoxCalculator.getBoundingBox(this.editorCanvas.getObjectEnumerator().getDrawableObjects());
        }
        catch (Exception e) {
            this.objectBBox = new FigBbox(0, 0, 1000, 1000);
        }
        this.visibleRegionBBox = this.editorCanvas.getVisibleRegionBoundingBox();
        this.totalBBox = this.visibleRegionBBox.union(this.objectBBox);
        if (debug) {
            CanvasScroller.msg("-I- rebuildBoundingBoxes:\nobjects: " + this.objectBBox + "\nvisib: " + this.visibleRegionBBox + "\ntotal: " + this.totalBBox);
        }
    }

    public void setObjectBoundingBox(int xl, int yt, int xr, int yb) {
        this.objectBBox = new FigBbox(xl, yt, xr, yb);
        this.rebuildBoundingBoxes();
        this.rebuildScrollbars();
    }

    public void setClipToObjectBoundingBox(boolean b) {
        this.clipToObjectBoundingBox = b;
        this.rebuildBoundingBoxes();
        this.rebuildScrollbars();
    }

    public void rebuildScrollbars() {
        int dx_visible = this.visibleRegionBBox.getXr() - this.visibleRegionBBox.getXl();
        int dy_visible = this.visibleRegionBBox.getYb() - this.visibleRegionBBox.getYt();
        int dx_total = this.totalBBox.getXr() - this.totalBBox.getXl();
        int dy_total = this.totalBBox.getYb() - this.totalBBox.getYt();
        int amount_x = this.clip((int)(1000.0 * (double)dx_visible / (double)dx_total), 10, 980);
        int amount_y = this.clip((int)(1000.0 * (double)dy_visible / (double)dy_total), 10, 980);
        int xl_visible = this.visibleRegionBBox.getXl();
        int yt_visible = this.visibleRegionBBox.getYt();
        int xl_total = this.totalBBox.getXl();
        int yt_total = this.totalBBox.getYt();
        int value_x = this.clip((int)(1000.0 * (double)(xl_visible - xl_total) / (double)(dx_total + 1)), 10, 990);
        int value_y = this.clip((int)(1000.0 * (double)(yt_visible - yt_total) / (double)(dy_total + 1)), 10, 990);
        this.scrollbarX.setValues(value_x, amount_x, 0, 1000);
        this.scrollbarY.setValues(value_y, amount_y, 0, 1000);
        if (debug) {
            CanvasScroller.msg("-#- CS.rebuildScrollbars:  X: " + value_x + "," + amount_x + " Y: " + value_y + "," + amount_y);
        }
    }

    public int clip(int value, int min_value, int max_value) {
        if (value > max_value) {
            return max_value;
        }
        if (value < min_value) {
            return min_value;
        }
        return value;
    }

    public void componentHidden(ComponentEvent evt) {
    }

    public void componentMoved(ComponentEvent evt) {
    }

    public void componentShown(ComponentEvent evt) {
        this.rebuildBoundingBoxes();
        this.rebuildScrollbars();
    }

    public void componentResized(ComponentEvent evt) {
        this.rebuildBoundingBoxes();
        this.rebuildScrollbars();
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (evt.getSource() == this.scrollbarX) {
            switch (evt.getAdjustmentType()) {
                case 2: {
                    this.editorCanvas.doPanning(1, false);
                    break;
                }
                case 1: {
                    this.editorCanvas.doPanning(2, false);
                    break;
                }
                case 3: {
                    this.editorCanvas.doPanning(1, true);
                    break;
                }
                case 4: {
                    this.editorCanvas.doPanning(2, true);
                    break;
                }
                default: {
                    if (debug) {
                        CanvasScroller.msg("-I- event ignored: " + evt);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (evt.getSource() == this.scrollbarY) {
            switch (evt.getAdjustmentType()) {
                case 2: {
                    this.editorCanvas.doPanning(3, false);
                    break;
                }
                case 1: {
                    this.editorCanvas.doPanning(4, false);
                    break;
                }
                case 3: {
                    this.editorCanvas.doPanning(3, true);
                    break;
                }
                case 4: {
                    this.editorCanvas.doPanning(4, true);
                    break;
                }
                default: {
                    if (debug) {
                        CanvasScroller.msg("-I- event ignored: " + evt);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            CanvasScroller.msg("-E- unknown event source: " + evt);
        }
        this.rebuildBoundingBoxes();
        this.rebuildScrollbars();
    }

    public void trackScrollbarX() {
        int x_scroll = this.scrollbarX.getValue();
        int x_max_scroll = this.scrollbarX.getMaximum();
        int x_left = this.totalBBox.getXl();
        int x_size = this.totalBBox.getXr() - this.totalBBox.getXl();
        int wx = x_left + x_scroll * x_size / x_max_scroll;
        Point anchor = this.editorCanvas.getTrafo().getAnchor();
        anchor.x = wx;
        this.editorCanvas.getTrafo().setAnchor(anchor);
        this.editorCanvas.doFullRedraw(200L);
    }

    public void trackScrollbarY() {
        int y_scroll = this.scrollbarY.getValue();
        int y_max_scroll = this.scrollbarY.getMaximum();
        int y_top = this.totalBBox.getYt();
        int y_size = this.totalBBox.getYb() - this.totalBBox.getYt();
        int wy = y_top + y_scroll * y_size / y_max_scroll;
        Point anchor = this.editorCanvas.getTrafo().getAnchor();
        anchor.y = wy;
        this.editorCanvas.getTrafo().setAnchor(anchor);
        this.editorCanvas.doFullRedraw(200L);
    }

    public void mouseMoved(MouseEvent evt) {
        Point P = this.editorCanvas.getTrafo().getWorldCoordsSnapped(evt.getX(), evt.getY());
        this.infoLabel.setX(P.x);
        this.infoLabel.setY(P.y);
        this.infoLabel.repaint(100L);
    }

    public void mouseDragged(MouseEvent evt) {
        Point P = this.editorCanvas.getTrafo().getWorldCoordsSnapped(evt.getX(), evt.getY());
        this.infoLabel.setX(P.x);
        this.infoLabel.setY(P.y);
        this.infoLabel.repaint(100L);
    }

    public void zoomChanged(Object arg) {
        if (debug) {
            CanvasScroller.msg("-#- CanvasScroller.zoomChanged: " + arg);
        }
        this.rebuildBoundingBoxes();
        this.rebuildScrollbars();
        this.infoLabel.setZoom(this.editorCanvas.getTrafo().getZoomFactor());
        this.infoLabel.repaint(100L);
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] argv) {
        CanvasScroller.msg("CanvasScroller selftest, please wait...");
        TopLeftRulerCanvas editorCanvas = new TopLeftRulerCanvas();
        editorCanvas.setBackground(Color.white);
        editorCanvas.setGrid(240);
        CanvasScroller SEC = new CanvasScroller((FigCanvas)editorCanvas);
        FigCanvas figCanvas = SEC.editorCanvas;
        CanvasScroller canvasScroller = SEC;
        canvasScroller.getClass();
        figCanvas.setObjectEnumerator(canvasScroller.new DummyObjectEnumerator((FigCanvas)editorCanvas));
        Frame frame = new Frame("CanvasScroller Demo...");
        frame.add("Center", SEC);
        frame.setSize(new Dimension(400, 300));
        frame.setVisible(true);
    }

    class DummyObjectEnumerator
    implements FigDrawableEnumerator {
        Vector vector = new Vector();

        DummyObjectEnumerator(FigCanvas canvas) {
            FigAttribs attribs = new FigAttribs();
            FigTrafo2D trafo = canvas.getTrafo();
            this.vector.addElement(new FigText(new Point(5000, 5000), "Hugo!", attribs, trafo));
            this.vector.addElement(new FigText(new Point(15000, 5000), "Gabi", attribs, trafo));
            this.vector.addElement(new FigText(new Point(5000, 15000), "Claudia", attribs, trafo));
        }

        public Enumeration getDrawableObjects() {
            return this.vector.elements();
        }

        public FigDrawable getTmpObject() {
            return null;
        }
    }

    class InfoLabel
    extends Canvas {
        private Dimension dimension;
        private Font textFont = new Font("MonoSpaced", 0, 12);
        private FontMetrics fm;
        private Format XF = new Format("%05d");
        private Format ZF = new Format("%7.2f");
        int xoffset = 10;
        int baseline;
        int font_height = 40;
        int x;
        int y;
        double zoomFactor;

        public InfoLabel() {
            this.setBackground(Color.lightGray);
            this.setFont(this.textFont);
            this.dimension = new Dimension(100, 50);
            this.x = 0;
            this.y = 0;
            this.zoomFactor = 1.0;
        }

        public int measure() {
            this.fm = FontCache.getFontCache().getFontMetrics(this.textFont);
            this.baseline = this.fm.getMaxAscent() + (this.dimension.height - this.fm.getHeight()) / 2 + 1;
            this.font_height = this.fm.getMaxAscent() + this.fm.getDescent();
            if (debug) {
                CanvasScroller.msg("-I- CanvasScroller.measure: height=" + this.dimension.height + " baseline= " + this.baseline + " fmMaxAscent= " + this.fm.getMaxAscent() + " fmAscent= " + this.fm.getAscent());
            }
            return this.xoffset + this.fm.stringWidth(this.getInfoLabel()) + this.xoffset;
        }

        public void setWidth(int w) {
            this.dimension.width = w;
        }

        public void setHeight(int h) {
            this.dimension.height = Math.max(h, this.font_height);
            this.baseline = this.fm.getMaxAscent() + (this.dimension.height - this.fm.getHeight()) / 2 + 1;
        }

        public void setX(int _x) {
            this.x = _x;
        }

        public void setY(int _y) {
            this.y = _y;
        }

        public void setZoom(double _z) {
            this.zoomFactor = _z;
        }

        public String getInfoLabel() {
            return "(" + this.XF.form(this.x) + "," + this.XF.form(this.y) + ") " + this.ZF.form(100.0 * this.zoomFactor) + "% ";
        }

        public Dimension getPreferredSize() {
            return this.dimension;
        }

        public Dimension getMinimumSize() {
            return this.dimension;
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(this.getForeground());
            g.drawString(this.getInfoLabel(), this.xoffset, this.baseline);
        }
    }

    class Filler
    extends Canvas {
        private Dimension dimension;

        public Filler() {
            this.setBackground(Color.lightGray);
            this.dimension = new Dimension(20, 20);
        }

        public void setWidth(int w) {
            this.dimension.width = w;
        }

        public void setHeight(int h) {
            this.dimension.height = h;
        }

        public Dimension getPreferredSize() {
            return this.dimension;
        }

        public Dimension getMinimumSize() {
            return this.dimension;
        }
    }
}

