/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.symbols.PortSymbol;
import hades.symbols.Symbol;
import hades.symbols.WireSegment;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigObject;

public class AutoconnectCommand
extends Command {
    Point oldPos;
    Symbol symbol;
    SimObject target;
    ObjectCanvas canvas;

    public AutoconnectCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.statusMessage("Please click on the SimObject to autoconnect:");
        this.ready = false;
        this.oldPos = null;
    }

    public void execute() {
        this.autoconnect();
        this.statusMessage("Ready. Please select a command.");
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    private void autoconnect() {
        if (Command.debug) {
            this.message("AC: found SimObject: " + this.target);
        }
        String[] portnames = this.symbol.getPortNames();
        Port port = null;
        PortSymbol tmp = null;
        FigObject obj = null;
        Point WP = null;
        int i = 0;
        while (i < portnames.length) {
            tmp = this.symbol.getPortSymbol(portnames[i]);
            WP = tmp.getPosition();
            port = this.editor.findPort(WP);
            if (port == null) {
                this.message("-E- Internal error: Port '" + portnames[i] + "' not found on object " + this.target);
            } else if (port.getSignal() == null) {
                if (Command.debug) {
                    this.message("AC:found Port=" + port + " at pos= " + WP);
                }
                if ((obj = this.editor.findSymbolOrSignal(WP)) instanceof WireSegment) {
                    Signal signal = ((WireSegment)obj).getSignal();
                    signal.connect(port);
                    if (Command.debug) {
                        this.message("AC: connected to signal: " + signal);
                    }
                }
            }
            ++i;
        }
    }

    public void undo() {
        this.message("-W- Cannot undo an AutoConnect command. Workaround: ");
        this.message("    Copy the object, then delete the original. ");
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        this.oldPos = WP;
        this.symbol = this.editor.findSymbol(WP);
        if (this.symbol == null) {
            this.message("-W- Autoconnect: No object at that position! ");
            this.statusMessage("Autoconnect: please click directly on the object");
            this.ready = false;
            return;
        }
        this.target = this.symbol.getParent();
        this.execute();
        this.ready = true;
    }

    public String toString() {
        return "AutoconnectCommand at: " + this.oldPos + " target: " + this.target;
    }

    public String getDescription() {
        return "autoconnect object";
    }

    static {
        Command.versionString = "HADES AutoconnectCommand 0.1 (12.11.97)";
    }
}

