/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.gui.SyncRedrawTimer;
import hades.gui.Trafo2D;
import hades.manager.DesignManager;
import hades.utils.NameMangler;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jfig.canvas.FigDrawable;
import jfig.canvas.FigTrafo2D;
import jfig.canvas.TopLeftRulerCanvas;
import jfig.objects.FigBbox;
import jfig.utils.SetupManager;

public class AWTObjectCanvas
extends TopLeftRulerCanvas
implements ObjectCanvas,
ActionListener {
    static final String versionString = "HADES AWTObjectCanvas 0.6 (27.10.99)";
    private boolean toolTipsEnabledFlag;
    private boolean enablePopup;
    private boolean enablePopupOnNextMouseRelease;
    private boolean isPopupShowingFlag;
    private PopupMenu popup;
    private Point popupPosition;
    private Point popupPositionWC;
    private Hashtable menuTable = new Hashtable();
    private Editor editor;
    public static final int MAX_REPAINT_INDEX = 100;
    private FigDrawable[] repaintArray;
    private int repaintIndex;
    private boolean repaintOverflow;
    private SyncRedrawTimer syncRedrawTimer;
    private int n_syncrepaints = 0;
    protected int n_repaintTables = 0;
    protected int n_repaintTableEntries = 0;
    protected int n_repaintOverflows = 0;

    public AWTObjectCanvas(Editor _editor) {
        this.setTrafo(new Trafo2D());
        if (SetupManager.getBoolean("Hades.Editor.ViewMode", false)) {
            this.showRulers(false);
            this.setGrid(0);
        }
        this.editor = _editor;
        this.repaintArray = new FigDrawable[100];
        this.repaintIndex = 0;
        this.repaintOverflow = false;
        this.syncRedrawTimer = new SyncRedrawTimer(this);
        this.syncRedrawTimer.start();
        this.createPopup();
        this.enablePopupOnNextMouseRelease = false;
        this.setEnablePopup(true);
    }

    public SyncRedrawTimer getSyncRedrawTimer() {
        return this.syncRedrawTimer;
    }

    private void createPopup() {
        this.popup = new PopupMenu();
        this.menuTable.put("popup", this.popup);
        try {
            String menuResourceName = SetupManager.getProperty("Hades.Editor.PopupMenuResource", "/hades/gui/PopupMenu.txt");
            BufferedReader BR = new BufferedReader(new InputStreamReader(DesignManager.getDesignManager().getInputStream(null, menuResourceName)));
            String line = null;
            String menuname = null;
            String parentname = null;
            StringTokenizer st = null;
            Menu menu = null;
            Menu parent = null;
            while ((line = BR.readLine()) != null) {
                try {
                    st = new StringTokenizer(line, " \t");
                    String opcode = st.nextToken();
                    if (line.startsWith("#")) continue;
                    if ("Menu".equals(opcode)) {
                        menuname = this.getToken(st);
                        menu = new Menu(menuname);
                        this.menuTable.put(menuname, menu);
                        this.popup.add(menu);
                        continue;
                    }
                    if ("SubMenu".equals(opcode)) {
                        parentname = this.getToken(st);
                        menuname = this.getToken(st);
                        menu = new Menu(menuname);
                        this.menuTable.put(menuname, menu);
                        parent = this.findMenu(this.popup, parentname);
                        if (parent == null) continue;
                        parent.add(menu);
                        continue;
                    }
                    if ("MenuSeparator".equals(opcode)) {
                        parentname = this.getToken(st);
                        parent = this.findMenu(this.popup, parentname);
                        if (parent == null) continue;
                        parent.addSeparator();
                        continue;
                    }
                    if ("MenuItem".equals(opcode)) {
                        parentname = this.getToken(st);
                        String itemname = this.getToken(st);
                        String callback = this.getToken(st);
                        String argument = this.getToken(st);
                        MenuItem item = new MenuItem(itemname);
                        if (this.editor != null) {
                            item.addActionListener(this.editor);
                            this.editor.addCallback(itemname, callback, argument);
                        }
                        if ((parent = this.findMenu(this.popup, parentname)) != null) {
                            parent.add(item);
                            continue;
                        }
                        this.popup.add(item);
                        continue;
                    }
                    System.err.println("-W- ignoring popup menu entry ': " + line + "'");
                }
                catch (Exception e) {
                    System.err.println("-E- invalid popup menu entry: '" + line + "'");
                }
            }
            BR.close();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        this.popupPosition = new Point(-1, -1);
        this.popupPositionWC = new Point(-1, -1);
        this.add(this.popup);
    }

    public String getToken(StringTokenizer st) throws Exception {
        return NameMangler.decodeUnicodeEscapes(st.nextToken());
    }

    public Menu findMenu(Menu parent, String menuname) {
        return (Menu)this.menuTable.get(menuname);
    }

    public Menu findMenuSlow(Menu parent, String menuname) {
        int n_items = parent.getItemCount();
        int i = 0;
        while (i < n_items) {
            MenuItem tmp = parent.getItem(i);
            if (tmp instanceof Menu) {
                if (menuname.equals(tmp.getLabel())) {
                    return (Menu)tmp;
                }
                Menu result = this.findMenu((Menu)tmp, menuname);
                if (result != null) {
                    return result;
                }
            }
            ++i;
        }
        return null;
    }

    public void createMenuShortcuts() {
    }

    public boolean isPopupShowing() {
        return this.isPopupShowingFlag;
    }

    public Point getPopupPosition() {
        return this.popupPosition;
    }

    public Point getPopupPositionWC() {
        return this.popupPositionWC;
    }

    public Point getPopupPositionWCsnapped() {
        Point wp = new Point(0, 0);
        wp = this.getTrafo().screen_to_wc_snapped(this.popupPosition, wp);
        return wp;
    }

    public void setPopupPosition(Point sp, Point wp) {
        this.popupPosition = new Point(sp);
        this.popupPositionWC = new Point(wp);
    }

    public void setEnablePopup(boolean b) {
        this.enablePopup = b;
    }

    public boolean getEnablePopup() {
        return this.enablePopup;
    }

    public void setEnablePopupOnNextMouseRelease() {
        this.enablePopupOnNextMouseRelease = true;
    }

    public boolean isToolTipsEnabled() {
        return this.toolTipsEnabledFlag;
    }

    public void setToolTipsEnabled(boolean b) {
        this.toolTipsEnabledFlag = b;
    }

    public void mouseMoved(MouseEvent mme) {
        this.isPopupShowingFlag = false;
        super.mouseMoved(mme);
    }

    public void mousePressed(MouseEvent e) {
        if (this.enablePopup && e.isPopupTrigger()) {
            this.popupPosition = new Point(e.getX(), e.getY());
            this.popupPositionWC = this.getTrafo().screen_to_wc_snapped(this.popupPosition, new Point(0, 0));
            this.isPopupShowingFlag = true;
            this.writeLogPopupPosition();
            this.popup.show((Component)((Object)this), e.getX(), e.getY());
            this.sleep(50);
        } else {
            this.isPopupShowingFlag = false;
            super.mousePressed(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.enablePopupOnNextMouseRelease) {
            this.enablePopup = true;
            this.enablePopupOnNextMouseRelease = false;
        } else if (this.enablePopup && e.isPopupTrigger()) {
            this.popupPosition = new Point(e.getX(), e.getY());
            this.popupPositionWC = this.getTrafo().screen_to_wc_snapped(this.popupPosition, new Point(0, 0));
            this.isPopupShowingFlag = true;
            this.writeLogPopupPosition();
            this.popup.show((Component)((Object)this), e.getX(), e.getY());
            this.sleep(50);
        } else {
            this.isPopupShowingFlag = false;
            super.mouseReleased(e);
        }
    }

    private void writeLogPopupPosition() {
        if (this.editor == null) {
            return;
        }
        if (this.editor.getLogManager() == null) {
            return;
        }
        this.editor.getLogManager().writeShowPopupPosition(this.popupPosition, this.popupPositionWC);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.debug) {
            System.out.println("AWTObjectCanvas.actionPerformed: " + e);
        }
        if (e.getSource() instanceof MenuItem) {
            String s = e.getActionCommand();
            System.out.println("Popup-MenuItem: " + s);
        }
    }

    public synchronized void doPanning(int direction, boolean shift) {
        this.getCurrentCanvasSize();
        Point tmp_sc = new Point();
        Point tmp_wc = new Point();
        tmp_sc.x = this.cur_width;
        tmp_sc.y = this.cur_height;
        tmp_wc = this.trafo.screen_to_wc(tmp_sc, tmp_wc);
        Point anchor = this.trafo.getAnchor();
        if (this.debug) {
            this.msg("-#- AWTObjectCanvas.doPanning: anchor=" + anchor);
        }
        double w = shift ? 0.5 : 0.04;
        int dx = (int)((double)(tmp_wc.x - anchor.x) * w);
        int dy = (int)((double)(tmp_wc.y - anchor.y) * w);
        switch (direction) {
            case 0: {
                anchor.x = this.BASE_ANCHOR_X;
                anchor.y = this.BASE_ANCHOR_Y;
                this.trafo.setAnchor(anchor);
                break;
            }
            case 2: {
                anchor.x += dx;
                this.trafo.setAnchor(anchor);
                break;
            }
            case 1: {
                anchor.x -= dx;
                this.trafo.setAnchor(anchor);
                break;
            }
            case 4: {
                anchor.y += dy;
                this.trafo.setAnchor(anchor);
                break;
            }
            case 3: {
                anchor.y -= dy;
                this.trafo.setAnchor(anchor);
                break;
            }
            default: {
                this.msg("-E- AWTObjectCanvas.doPanning: unknown direction " + direction);
            }
        }
        this.doFullRedraw();
        this.notifyZoomListeners();
    }

    public synchronized void doZoomIn14() {
        if (this.debug) {
            this.msg("AWTObjectCanvas.doZoomIn14()");
        }
        if (this.trafo.getZoomFactor() >= this.trafo.getMaxZoomFactor()) {
            this.msg("already at maximum zoom factor...");
        } else {
            double f_zoom = this.trafo.getZoomFactor();
            if (this.debug) {
                System.out.println("zoom factor is=" + f_zoom);
            }
            this.setCursor(this.waitCursor);
            Rectangle r = this.getBounds();
            Point s_bottomright = new Point(r.width, r.height);
            Point w_bottomright = new Point(0, 0);
            w_bottomright = this.trafo.screen_to_wc(s_bottomright, w_bottomright);
            Point w_anchor = this.trafo.getAnchor();
            int w_dx = w_bottomright.x - w_anchor.x;
            int w_dy = w_bottomright.y - w_anchor.y;
            this.trafo.set_zoom_region(w_anchor.x + (int)(0.14645 * (double)w_dx), w_anchor.y + (int)(0.14645 * (double)w_dy), w_anchor.x + (int)(0.85355 * (double)w_dx), w_anchor.y + (int)(0.85355 * (double)w_dy), r.width, r.height);
            this.doFullRedraw();
            this.setCursor(this.defaultCursor);
            this.notifyZoomListeners();
        }
    }

    public synchronized void doZoomOut07() {
        if (this.debug) {
            this.msg("AWTObjectCanvas.doZoomOut07()");
        }
        if (this.trafo.getZoomFactor() <= this.trafo.getMinZoomFactor()) {
            this.msg("already at minimum zoom factor...");
        } else {
            double f_zoom = this.trafo.getZoomFactor();
            if (this.debug) {
                System.out.println("zoom factor is=" + f_zoom);
            }
            this.setCursor(this.waitCursor);
            Rectangle r = this.getBounds();
            Point s_bottomright = new Point(r.width, r.height);
            Point w_bottomright = new Point(0, 0);
            w_bottomright = this.trafo.screen_to_wc(s_bottomright, w_bottomright);
            Point w_anchor = this.trafo.getAnchor();
            int w_dx = w_bottomright.x - w_anchor.x;
            int w_dy = w_bottomright.y - w_anchor.y;
            this.trafo.set_zoom_region(w_anchor.x - (int)(0.2071 * (double)w_dx), w_anchor.y - (int)(0.2071 * (double)w_dy), w_anchor.x + (int)(1.2071 * (double)w_dx), w_anchor.y + (int)(1.2071 * (double)w_dy), r.width, r.height);
            this.doFullRedraw();
            this.setCursor(this.defaultCursor);
            this.notifyZoomListeners();
        }
    }

    public synchronized void doZoomRegionBroken(FigBbox bbox) {
        if (this.debug) {
            this.msg("-I- AWTObjectCanvas.doZoomRegion: " + bbox);
        }
        int xl = bbox.getXl();
        int xr = bbox.getXr();
        int yt = bbox.getYt();
        int yb = bbox.getYb();
        int wc_ruler_width = this.getTrafo().screen_to_wc(25);
        Rectangle r = this.getBounds();
        this.setCursor(this.waitCursor);
        this.trafo.set_zoom_region(xl -= 2 * wc_ruler_width, yt -= 2 * wc_ruler_width, xr += 1 * wc_ruler_width, yb += 1 * wc_ruler_width, r.width, r.height);
        this.doFullRedraw();
        this.setCursor(this.defaultCursor);
        this.notifyZoomListeners();
    }

    public synchronized void doZoomRegion(FigBbox bbox) {
        if (this.debug) {
            this.msg("-I- AWTObjectCanvas.doZoomRegion: " + bbox);
        }
        int border = 10;
        Rectangle r = this.getBounds();
        this.setCursor(this.waitCursor);
        ((Trafo2D)this.trafo).set_zoom_region_unconstrained(bbox.getXl(), bbox.getYt(), bbox.getXr(), bbox.getYb(), r.width, r.height, border);
        this.doFullRedraw();
        this.setCursor(this.defaultCursor);
        this.notifyZoomListeners();
    }

    public synchronized void doZoomLandscapeA4(FigBbox bbox) {
        if (this.debug) {
            this.msg("-I- AWTObjectCanvas.doZoomRegion: " + bbox);
        }
        int border = 50;
        Rectangle r = new Rectangle(840, 594);
        this.setCursor(this.waitCursor);
        ((Trafo2D)this.trafo).set_zoom_region_unconstrained(bbox.getXl(), bbox.getYt(), bbox.getXr(), bbox.getYb(), r.width, r.height, border);
        this.doFullRedraw();
        this.setCursor(this.defaultCursor);
        this.notifyZoomListeners();
    }

    public synchronized void paint(FigDrawable obj) {
        this.putIntoRepaintArray(obj);
        ++this.n_repaintTableEntries;
    }

    public synchronized void paint(FigDrawable obj, int millis) {
        this.putIntoRepaintArray(obj);
        ++this.n_repaintTableEntries;
    }

    private void putIntoRepaintArray(FigDrawable obj) {
        if (this.repaintOverflow) {
            return;
        }
        if (obj.getSyncRedrawFlag()) {
            return;
        }
        obj.setSyncRedrawFlag(true);
        this.repaintArray[this.repaintIndex] = obj;
        ++this.repaintIndex;
        if (this.repaintIndex >= 99) {
            if (this.debug) {
                this.msg("-W- AWTObjectCanvas: repaintOverflow: " + this.repaintIndex);
            }
            ++this.n_repaintOverflows;
            this.repaintOverflow = true;
        }
    }

    private void fastClearRepaintArray() {
        int i = 0;
        while (i < this.repaintIndex) {
            this.repaintArray[i].setSyncRedrawFlag(false);
            ++i;
        }
        this.repaintIndex = 0;
        this.repaintOverflow = false;
    }

    public void clearRepaintArray() {
        int i = 0;
        while (i < this.repaintIndex) {
            this.repaintArray[i] = null;
            ++i;
        }
        this.repaintIndex = 0;
        this.repaintOverflow = false;
    }

    public int countPendingRepaints() {
        return this.repaintIndex;
    }

    public int countRepaintTableEntries() {
        return this.n_repaintTableEntries;
    }

    public int countSyncRepaintOverflows() {
        return this.n_repaintOverflows;
    }

    public int countExecutedSyncRepaints() {
        return this.n_syncrepaints;
    }

    public synchronized void bufferedSyncRedraw() {
        this.doSyncRedraw();
    }

    public String printRepaintStatus() {
        return "AWTObjectCanvas: repaintTables= " + this.n_repaintTables + " entries= " + this.n_repaintTableEntries + " overflows= " + this.n_repaintOverflows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doSyncRedraw() {
        ++this.n_syncrepaints;
        if (this.countPendingRepaints() == 0) {
            return;
        }
        if (this.objectGR == null) {
            return;
        }
        FigTrafo2D trafo = this.getTrafo();
        FigDrawable obj = null;
        if (this.repaintOverflow) {
            FigDrawable[] figDrawableArray = this.repaintArray;
            synchronized (this.repaintArray) {
                this.fastClearRepaintArray();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.redrawMode |= 0x80;
                this.repaint();
            }
        } else {
            int i = 0;
            while (i < this.repaintIndex) {
                obj = this.repaintArray[i];
                obj.paint(this.objectGR, trafo);
                obj.setSyncRedrawFlag(false);
                ++i;
            }
            this.repaintIndex = 0;
            this.redrawMode |= 4;
            this.repaint();
        }
        {
            ++this.n_repaintTables;
            return;
        }
    }

    public void sleep(int millis) {
    }

    public static void main(String[] argv) {
        Frame frame = new Frame("AWTObjectCanvas selftest");
        AWTObjectCanvas objectCanvas = new AWTObjectCanvas(null);
        frame.add("Center", (Component)((Object)objectCanvas));
        frame.setVisible(true);
        frame.setSize(400, 400);
        frame.validate();
    }
}

